Modelo `LaTeX` para monografias da Universidade de Évora
========================================================

Resumo
------

* Aplicar a [identidade visual corporativa](http://www.uevora.pt/media_informacoes/Identidade-Visual-Corporativa) e os modelos definidos pelo [IIFA](http://www.iifa.uevora.pt/documentos/Doutorandos);
* Facilitar a tarefa de normalizar o aspecto das dissertações na UE;
*  O desenvolvimento, com (alguma) documentação e as versões e correcções de erros mais recentes, ocorre [aqui](https://git.xdi.uevora.pt/fc/teseue);
* A versão mais recente pode ser obtida [aqui](teseue.zip);
* O aspecto final é [este](main.pdf);


Instalação
----------

Basta colocar os ficheiros na directoria onde se pretende usar este modelo.

Uso comum
---------

São proporcionados dois modos alternativos de uso:

- organização da dissertação completa; 
- geração da capa, sub-capa, contra-capa e lombada;

Em ambos os modos a informação sobre o título, autor, orientadores, _etc_ é definida no ficheiro `main.tex`.

A selecção de um modo ou do outro é indicada pelo comando

- `\tueDOCUMENTO` para a organização da dissertação completa;
- `\tueCAPAS` apenas para gerar a capa, sub-capa, contra-capa e lombada;

que deve constar na última linha do ficheiro `main.tex`.

## O ficheiro `main.tex`

O ficheiro `main.tex` define os parâmetros individuais da monografia, o grau (mestrado ou doutoramento) a que se destina e o modo (organização da dissertação ou geração das capas). Tem a seguinte estrutura geral:
```
ALVOS
IDENTIFICAÇÃO
MODO
```

### Alvos

Determinam o grau, a área científica e a qualidade da imagem da capa (final ou rascunho). Tem o seguinte aspecto, por exemplo para um rascunho de um doutoramento na área de ciências e tecnologia:
```tex
\documentclass[doutoramento,ctR,12pt]{teseue}
```
	
* Grau: `doutoramento` ou `mestrado`;
* Área científica:
	- **Ciência e Tecnologia**: `ct` (final) ou `ctR` (rascunho);
	- **Ciências Sociais e Humanas**: `csh` (final) ou `cshR` (rascunho);
	- **Artes**: `artes` (final) ou `artesR` (rascunho);
	- As opções **finais** usam imagens de melhor qualidade e são indicadas para a impressão final;
	- As opções **rascunho** usam imagens de menor tamanho, o que é **indicado para correspondência electrónica mas não para a impressão final**.

### Identificação

A identificação da dissertação (título e subtítulo, nome do candidato, _etc_) é definida usando um conjunto de comandos descritos abaixo. São contempladas opções para incluir uma especialidade e um, dois ou três orientadores.

- o título: `\tueTITULO{...}`
- o sub-título: `\tueSUBTITULO{...}`
- o nome do candidato: `\tueCANDIDATO{...}`
- o curso: `\tueCURSO{...}`
- (opcional) a especialidade: `\tueESPECIALIDADE{...}`
- o título e nome do/a orientador/a: `\tueORIENTADOR{ <titulo> }{ <nome> }`
- (opcional) o título e nome do/a segundo/a orientador/a: `\tueSEGUNDOORIENTADOR{ <titulo> }{ <nome> }`
- (opcional) o título e nome do/a terceiro/a orientador/a: `\tueTERCEIROORIENTADOR{ <titulo> }{ <nome> }`
- o departamento: `\tueDEPARTAMENTO{...}`
- a escola: `\tueESCOLA{...}`
- a data da dissertação: `\tueDATA{...}`
- a dedicatória: `\tueDEDICATORIA{...}`

### Modo

O modo determina se vai ser organizado e produzido todo o texto da dissertação ou se apenas vão ser geradas a capa, sub-capa, contra-capa e lombada. Para seleccionar o modo pretendido basta escolher entre `\tueDOCUMENTO` ou `\tueCAPAS` (respectivamente para produzir o texto ou apenas gerar a capa) na última linha do ficheiro `main.tex`.


Pressupostos e convenções
-------------------------

* Sistema operativo: indiferente, mas não foi testado em _Windows_;
* Distribuição do `TeX`: indiferente, desde que recente (menos de três anos) e que inclua o `xelatex`;
* Os documentos de texto têm de ser guardados com codificação `utf-8`. Os editores sugeridos abaixo têm essa opção;
* Para a opção de gerar apenas a capa, sub-capa, contra-capa e lombada é suficiente editar o ficheiro `main.tex`;


### Estrutura base das monografias

* Capa, Subcapa e Dedicatória
* Preâmbulo: antes da página 1; páginas com numerais romanos
	* Prefácio
	* Agradecimentos
	* Tabela de conteúdos, Lista de figuras, de tabelas e de acrónimos
	* Sumário
	* Abstract
* Conteúdo: da página 1 em diante; páginas com numerais árabes
	* Capítulos "comuns"
	* Apêndices
* Material Auxiliar
	* Bibliografia
	* Índice remissivo
* Contracapa

### Implementação da estrutura base
* **Preâmbulo `LaTeX`:** Comandos e definições `LaTeX` que **têm** de estar antes do início do texto
	- comandos do utilizador;
	- processamento os índices (`\makeindex`);
	- **Estas opções podem ser alteradas** com `\tuePREAMBULOLATEX{...}`

* **Preâmbulo do documento:** Texto antes da página 1
	- o prefácio (`\include{prefacio}`) definido no ficheiro `prefacio.tex`
	- os agradecimentos (`\include{agradecimentos}`) definidos no ficheiro `agradecimentos.tex`
	- a tabela de conteúdos (`\tableofcontents`), _gerada automaticamente_
	- a lista das figuras (`\listoffigures`), _gerada automaticamente_
	- a lista das tabelas (`\listoftables`), _gerada automaticamente_
	- a lista de acrónimos (`\include{acronimos}`)
	- o sumário (`\include{sumario}`) definido no ficheiro `sumario.tex`
	- a tradução do sumário (`\include{abstract}`) definido no ficheiro `abstract.tex`
	- **Estas opções podem ser alteradas** com `\tuePREAMBULO{...}`
* **Conteúdo principal:** Texto da página 1 em diante
	- vários capítulos normais (`\tueCONTEUDO{\include{...} \include{...} ...}`)
	- vários apêndices (`\tueAPENDICES{\include{...} \include{...} ...}`)
* **Material auxiliar** A bibliografia e o índice remissivo
	* **Bibliografia:** 
		- a bibliografia está definida no ficheiro `./bibliografia.bib` (`\bibliography{bibliografia}`)
		- são listadas **todas** as entradas desse ficheiro, mesmo que não sejam feitas referências no texto (`\nocite{*}`);
		- as referências são apresentadas, no texto, no estilo `alpha` (`\bibliographystyle{alpha}`)
		- **Estas opções podem ser alteradas** com `\tueBIBLIOGRAFIA{...}`
		- Há mais informações sobre referências bibliográficas em [BibTeX](http://www.bibtex.org/) ou com o comando `texdoc bibtex`
	* **Índice remissivo:** 
		- o índice remissivo é gerado automaticamente a partir dos comandos `\index` e `\printindex`
		- **Esta opção pode ser alterada** com `\tueINDICEREMISSIVO{...}`
		- Há mais informações sobre os índices remissivos com o comando `texdoc makeindex`

Informação _online_ sobre o `LaTeX`
-----------------------------------

* Entrada: [LaTeX Project](http://www.latex-project.org/)
* Perguntas/Respostas: [TeX@stackexchange](http://tex.stackexchange.com/)
* Editores
	* "principiante": [LyX](http://www.lyx.org/)
	* "iniciado": [Texmaker](http://www.xm1math.net/texmaker/) e [TeXstudio](http://texstudio.sourceforge.net/)
* Comunidade: [LaTeX Community](http://latex-community.org/)
* Exemplos: [TeXample.net](http://www.texample.net/)
* Modelos: [LaTeX Templates](http://www.latextemplates.com/)

Exemplo
-------
```tex
%!TEX program = xelatex
%
% ================================================================
%	Tipo de dissertação:
%		escolher entre "doutoramento" ou "mestrado"
%
%	Área científica:
%		escolher entre
%			- "ct" (ciências e tecnologia, final); "ctR" (ciências e tecnologia, rascunho);
%			- "csh" (ciências sociais e humanas, final); "cshR" (ciências sociais e humanas, rascunho);
%			- "artes" (artes, final); "artesR" (artes, rascunhos)
%
% ================================================================
%
\documentclass[doutoramento,ctR,12pt]{teseue}
%
%
% ================================================================
%	DOCUMENTO:
%
%		Título, Nome do Candidato, Curso, etc
%		Estrutura
% ================================================================
%
% ----------------------------------------------------------------
%
%	TÍTULO DA TESE
%
%	Em Português e Inglês.
%
\tueTITULO
{A Companhia Geral das Reais Pescarias do Reino do Algarve}
{The General Company of the Royal Fisheries of the Algarve Kingdom}
%
% ----------------------------------------------------------------
%
%	SUBTÍTULO DA TESE
%
%	Em Português e Inglês.
%
\tueSUBTITULO
{Controlar e fomentar a actividade da pesca no litoral sul do reino}
{Monitor and encourage the fishing activity in coastal southern kingdom}
%
% ----------------------------------------------------------------
%
%	CANDIDATO
%
%	Nome completo.
%		
\tueCANDIDATO
{Sebastião José de Carvalho e Melo}
%
% ----------------------------------------------------------------
%
%	TÍTULO E NOME DO/A ORIENTADOR/A
%
%	Designação oficial e nome do orientador/a.
%	Em geral, "Orientador" ou "Orientadora".
%
\tueORIENTADOR
{Orientador}
{José Francisco Agostinho de Bragança}
%
% ----------------------------------------------------------------
%
%	SEGUNDO ORIENTADOR/A (se aplicável)
%
%	Designação oficial e nome do segundo orientador/a.
%	Em geral, "Co-orientador" ou "Co-orientadora".
%
\tueSEGUNDOORIENTADOR
{Orientadora}
{Mariana Vitória de Bourbon}
%
% ----------------------------------------------------------------
%
%	TERCEIRO ORIENTADOR/A (se aplicável)
%
%	Designação oficial e nome do terceiro orientador/a.
%	Em geral, "Co-orientador" ou "Co-orientadora".
%
\tueTERCEIROORIENTADOR
{Co-Orientador}
{António Inácio Norberto}
%
% ----------------------------------------------------------------
%
%	CURSO
%
%	Nome do curso em que se enquadra esta tese.
%
\tueCURSO
{Secretaria Pública}
%
% ----------------------------------------------------------------
%
%	ESPECIALIDADE (se aplicável)
%
%	Nome da especialidade em que se enquadra esta tese.
%
\tueESPECIALIDADE
{Coordenação de Recursos Naturais}
%
% ----------------------------------------------------------------
%
%	DEPARTAMENTO
%
%	Departamento anfitrião do curso.
%
\tueDEPARTAMENTO
{Departamento de Administração Pública}
%
% ----------------------------------------------------------------
%
%	ESCOLA
%
%	Escola a que pertence o departamento.
%
\tueESCOLA
{Escola de Coordenação Nacional}
%
% ----------------------------------------------------------------
%
%	PALAVRAS CHAVE
%
%	Data de submissão da tese.
%
\tuePALAVRASCHAVE
{Companhia, Pesca, Reino do Algarve, Fomento, Controlo}
{Company, Fishery, Algarve Kingdom, Encouragement, Monitoring}
%
% ----------------------------------------------------------------
%
%	DATA
%
%	Data de submissão da tese.
%
\tueDATA
{\today}
%
% ----------------------------------------------------------------
%
%	DEDICATÓRIA
%
\tueDEDICATORIA
{Aos eternos insatisfeitos.}
%
% ----------------------------------------------------------------
%
%	PREAMBULO
%
%	Comandos e definições para o LaTeX que devem estar **antes**
%	do texto do documento.
%
%\tuePREAMBULOLATEX{}
%
% ----------------------------------------------------------------
%
%	PREAMBULO
%
%	Texto até à página 1. 
%
%	Por omissão os conteúdos estão definidos nos ficheiros
%		- prefacio.tex
%		- agradecimentos.tex
%		- acronimos.tex
%		- sumario.tex
%		- abstract.tex
%
%\tuePREAMBULO {}
%
% ----------------------------------------------------------------
%
%	CONTEÚDO
%
%	Texto principal da tese.
%
\tueCONTEUDO  % A partir da página 1
{
	\include{demo-cap-1}
	\include{demo-cap-2}
	\include{demo-cap-3}
}
%
% ----------------------------------------------------------------
%
%	APÊNDICES
%
%	Texto complementar da tese.
%
\tueAPENDICES % Material de suporte
{
	\include{demo-apend-1}
	\include{demo-apend-2}
}
%
% ----------------------------------------------------------------
%
%	BIBLIOGRAFIA
%
%	Por omissão...
%	- usa BibTex
%	- com o estilo "alpha"
%	- consulta o ficheiro "bibliografia.tex"
%	- lista **todas** as obras, mesmo que não referenciadas no texto da tese
%
%\tueBIBLIOGRAFIA{}
%
% ----------------------------------------------------------------
%
%	ÍNDICE REMISSIVO
%
%\tueINDICEREMISSIVO{}
%
% ----------------------------------------------------------------
%
% ================================================================
%
%	Modo ORGANIZAÇÃO DA DISSETAÇÃO COMPLETA.
%
%	Prevê que
%		- a informação sobre título, autor, orientadores, etc está definida acima e que
%		- a obra tem a seguinte estrutura:
%
%			prefácio
%			agradecimentos
%			tabela de conteúdos
%			lista de figuras
%			lista de tabelas
%			lista de acrónimos
%			sumário
%			tradução do sumário
%			------------------------------
%			CONTEÚDO (vários capítulos)
%			APÊNDICES (vários capítulos)
%			------------------------------
%			bibliografia
%			índice remissivo
%
% ================================================================
%
\tueDOCUMENTO
%
% ================================================================
%	Modo CAPA, CONTRA-CAPA e LOMBADAS.
%
%	Prevê que a informação sobre título, autor, orientadores, etc está definida acima.
%
% ================================================================
%
%\tueCAPAS
```